
<?php  
require 'includes/functions.php';  
  
// --- TANGANI PENCARIAN (TAMBAHKAN) ---  
$q = isset($_GET['q']) ? trim($_GET['q']) : '';  
if ($q !== '') {  
    // cari pada nama atau deskripsi (case-insensitive)  
    $results = [];  
    foreach($data['products'] as $p){  
        if (stripos($p['name'], $q) !== false || stripos($p['description'], $q) !== false){  
            $results[] = $p;  
        }  
    }  
  
    echo '<h3 class="mb-3">Hasil pencarian untuk <strong>'.htmlspecialchars($q).'</strong> — '.count($results).' ditemukan</h3>';  
  
    if (count($results) === 0){  
        echo '<div class="alert alert-light">Tidak ditemukan produk.</div>';  
    } else {  
        echo '<div class="row g-4">';  
        foreach($results as $p){  
            // tampilkan kartu produk sederhana (3 per baris di responsive)  
            $media = !empty($p['video']) ? '<video class="product-media" muted preload="metadata"><source src="'.htmlspecialchars($p['video']).'"></video>'  
                                        : '<img src="'.htmlspecialchars($p['image']).'" class="product-media">';  
            echo '<div class="col-12 col-md-4">';  
            echo '<div class="card card-modern h-100">';  
            echo $media;  
            echo '<div class="p-3">';  
            echo '<h5>'.htmlspecialchars($p['name']).'</h5>';  
            echo '<p class="small-muted">'.htmlspecialchars($p['description']).'</p>';  
            echo '<div class="d-flex justify-content-between align-items-center mt-2">';  
            echo '<div><strong>Rp '.number_format($p['price'],0,',','.').'</strong><br><small class="text-muted">Stok: '.(isset($p['stock'])?(int)$p['stock']:'-').'</small></div>';  
            echo '<div><a href="product.php?id='.$p['id'].'" class="btn btn-sm btn-outline-primary">Detail</a> ';  
            if (!empty($p['link'])) echo '<a href="visit.php?id='.$p['id'].'" class="btn btn-sm btn-primary">Kunjungi</a>';  
            echo '</div></div></div></div></div>';  
        }  
        echo '</div><hr class="my-4">';  
    }  
}  
  
$data = load_data();  
include 'includes/header.php';  
?>  
<h1 class="mb-4">Kategori</h1>  
<div class="row g-4">  
<?php foreach($data['categories'] as $cat):  
    $icon = !empty($cat['icon']) ? $cat['icon'] : 'https://via.placeholder.com/160x120?text=' . urlencode($cat['name']);  
?>  
  <div class="col-12 col-md-4">  
    <a href="category.php?id=<?php echo $cat['id']; ?>" class="text-decoration-none text-dark">  
      <div class="card shadow-sm h-100 p-3 d-flex align-items-start gap-3">  
        <img src="<?php echo $icon; ?>" class="me-3" style="width:72px;height:72px;object-fit:contain;border-radius:12px;background:#fff;padding:8px;">  
        <div>  
          <h5 class="mb-1"><?php echo htmlentities($cat['name']); ?></h5>  
          <p class="text-muted mb-0">Lihat produk &rarr;</p>  
        </div>  
      </div>  
    </a>  
  </div>  
<?php endforeach; ?>  
</div>  
<?php include 'includes/footer.php'; ?>  